/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_time_types.joda;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.basicsmappers.from_long.to_time_types.joda.Timezones;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class ToMillisAtStartOfNextDay
implements LongUnaryOperator {
    DateTimeZone tz = DateTimeZone.UTC;

    @Example(value={"ToMillisAtStartOfNextDay()", "return millisecond epoch time of the start of next day (not including day-of) of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfNextDay() {
    }

    @Example(value={"ToMillisAtStartOfNextDay('America/Chicago')", "return millisecond epoch time of the start of the next day (not including day-of) of the provided millisecond epoch time, using timezone America/Chicago"})
    public ToMillisAtStartOfNextDay(String timezoneId) {
        this.tz = Timezones.forId(timezoneId);
    }

    @Override
    public long applyAsLong(long operand) {
        return new DateTime(operand, this.tz).plusDays(1).withTimeAtStartOfDay().getMillis();
    }
}

