/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.stathelpers;

import java.nio.ByteBuffer;
import java.util.Iterator;

public class DiscreteProbabilityBuffer
implements Iterable<Entry> {
    private static int REFERENT_ID = 0;
    private static int PROBABILITY = REFERENT_ID + 4;
    public static int RECORD_LEN = PROBABILITY + 8;
    private double cumulativeProbability = 0.0;
    private boolean isNormalized = false;
    private final ByteBuffer buffer;

    public DiscreteProbabilityBuffer(int entries) {
        this.buffer = ByteBuffer.allocate(entries * RECORD_LEN);
    }

    public DiscreteProbabilityBuffer add(int i, double probability) {
        this.cumulativeProbability += probability;
        this.buffer.putInt(i);
        this.buffer.putDouble(probability);
        return this;
    }

    public void normalize(double phi) {
        if (Math.abs(this.cumulativeProbability - 1.0) < phi) {
            this.isNormalized = true;
        } else {
            this.normalize();
        }
    }

    public void normalize() {
        if (this.isNormalized) {
            throw new RuntimeException("Attempt to re-normalize the data. Allowing this might decrease accuracy.");
        }
        this.buffer.flip();
        if (this.buffer.capacity() % RECORD_LEN != 0) {
            throw new RuntimeException("Buffer must be exactly a multiple of " + RECORD_LEN + " bytes. It is " + this.buffer.capacity());
        }
        int records = this.buffer.capacity() / RECORD_LEN;
        for (int i = 0; i < records; ++i) {
            int doubleOffset = i * RECORD_LEN + PROBABILITY;
            double scalarProbability = this.buffer.getDouble(doubleOffset);
            double unitProbability = scalarProbability / this.cumulativeProbability;
            this.buffer.putDouble(doubleOffset, unitProbability);
        }
        this.cumulativeProbability = 1.0;
        this.isNormalized = true;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iter(this.buffer.duplicate());
    }

    public double getCumulativeProbability() {
        return this.cumulativeProbability;
    }

    public static class Entry {
        private int eventId;
        private double probability;

        public Entry(int eventId, double probability) {
            this.eventId = eventId;
            this.probability = probability;
        }

        public int getEventId() {
            return this.eventId;
        }

        public double getProbability() {
            return this.probability;
        }
    }

    private static class Iter
    implements Iterator<Entry> {
        private ByteBuffer iterbuf;

        public Iter(ByteBuffer iterbuf) {
            this.iterbuf = iterbuf;
        }

        @Override
        public boolean hasNext() {
            return this.iterbuf.remaining() > 0;
        }

        @Override
        public Entry next() {
            int eid = this.iterbuf.getInt();
            double prob = this.iterbuf.getDouble();
            return new Entry(eid, prob);
        }
    }
}

