/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class StringMap
implements LongFunction<Map<String, String>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> keyFunc;
    private final LongFunction<Object> valueFunc;

    @Example(value={"MapTemplate(false,HashRange(3,7),NumberNameToString(),HashRange(1300,1700))", "create a map of size 3-7 entries, with a key of type string and a value of type int (Integer by autoboxing)"})
    public StringMap(LongToIntFunction sizeFunc, LongFunction<Object> keyFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.keyFunc = keyFunc;
        this.valueFunc = valueFunc;
    }

    @Override
    public Map<String, String> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            Object keyObject = this.keyFunc.apply(value + (long)i);
            Object valueObject = this.valueFunc.apply(value + (long)i);
            map.put(keyObject.toString(), valueObject.toString());
        }
        return map;
    }
}

