/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_double;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class HashedDoubleRange
implements LongToDoubleFunction {
    private final double min;
    private final double max;
    private final double interval;
    private static final double MAX_DOUBLE_VIA_LONG = 9.223372036854776E18;
    private final Hash hash = new Hash();

    public HashedDoubleRange(double min, double max) {
        this.min = min;
        this.max = max;
        this.interval = max - min;
    }

    @Override
    public double applyAsDouble(long value) {
        long hashed = this.hash.applyAsLong(value);
        double unitScale = (double)hashed / 9.223372036854776E18;
        double valueScaled = this.interval * unitScale + this.min;
        return valueScaled;
    }
}

