/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_time_types;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class ToJodaDateTime
implements LongFunction<DateTime> {
    private long spacing;
    private long repeat_count;

    public ToJodaDateTime(int spacing, int repeat_count) {
        this.spacing = spacing;
        this.repeat_count = repeat_count;
    }

    public ToJodaDateTime(String spacing) {
        this(Integer.valueOf(spacing), 1);
    }

    public ToJodaDateTime() {
        this.spacing = 1L;
        this.repeat_count = 1L;
    }

    @Override
    public DateTime apply(long input) {
        input = input * this.spacing / this.repeat_count;
        return new DateTime(input, DateTimeZone.UTC);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.spacing + ":" + this.repeat_count;
    }
}

