/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_double;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class Interpolate
implements LongToDoubleFunction {
    private final double scale;
    private final double[] lut;
    private static final double maxLongAsDouble = 9.223372036854776E18;

    @Examples(value={@Example(value={"Interpolate(0.0d,100.0d)", "return a uniform double value between 0.0d and 100.0d"}), @Example(value={"Interpolate(0.0d,90.0d,95.0d,98.0d,100.0d)", "return a weighted double value where the first second and third quartiles are 90.0D, 95.0D, and 98.0D"})})
    public Interpolate(double ... values) {
        double[] doubles = new double[values.length + 1];
        for (int i = 0; i < values.length; ++i) {
            doubles[i] = values[i];
        }
        doubles[doubles.length - 1] = doubles[doubles.length - 2];
        this.scale = values.length - 1;
        this.lut = doubles;
    }

    @Override
    public double applyAsDouble(long input) {
        long value = input;
        double samplePoint = (double)input / 9.223372036854776E18 * this.scale;
        int leftidx = (int)samplePoint;
        double fractional = samplePoint - (double)((long)samplePoint);
        double leftComponent = this.lut[leftidx] * (1.0 - fractional);
        double rightComponent = this.lut[leftidx + 1] * fractional;
        double sample = leftComponent + rightComponent;
        return sample;
    }
}

