/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadLong
implements LongUnaryOperator {
    private final String name;
    private final LongFunction<Object> nameFunc;
    private long defaultValue;

    @Example(value={"LoadLong('foo',42L)", "for the current thread, load a long value from the named variable."})
    public LoadLong(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = 0L;
    }

    @Example(value={"LoadLong('foo',42L)", "for the current thread, load a long value from the named variable, or the default value if the named variable is not defined."})
    public LoadLong(String name, long defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"LoadLong(NumberNameToString(),42L)", "for the current thread, load a long value from the named variable,where the variable name is provided by a function."})
    public LoadLong(LongFunction<Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = 0L;
    }

    @Example(value={"LoadLong(NumberNameToString(),42L)", "for the current thread, load a long value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadLong(LongFunction<Object> nameFunc, long defaultValue) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public long applyAsLong(long operand) {
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(operand)) : this.name;
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        Object loaded = map.getOrDefault(varname, this.defaultValue);
        return (Long)loaded;
    }
}

