/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.distributions;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class WeightedStringsFromCSVAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "WeightedStringsFromCSV";
    }

    public String getPackageName() {
        return "io.virtdata.libbasics.shared.distributions";
    }

    public String getClassJavadoc() {
        return "Provides sampling of a given field in a CSV file according\nto discrete probabilities. The CSV file must have headers which can\nbe used to find the named columns for value and weight. The value column\ncontains the string result to be returned by the function. The weight\ncolumn contains the floating-point weight or mass associated with the\nvalue on the same line. All the weights are normalized automatically.\n\nIf there are multiple file names containing the same format, then they\nwill all be read in the same way.\n\nIf the first word in the filenames list is 'map', then the values will not\nbe pseudo-randomly selected. Instead, they will be mapped over in some\nother unsorted and stable order as input values vary from 0L to Long.MAX_VALUE.\n\nGenerally, you want to leave out the 'map' directive to get \"random sampling\"\nof these values.\n\nThis function works the same as the three-parametered form of WeightedStrings,\nwhich is deprecated in lieu of this one. Use this one instead.\n";
    }

    public String getInType() {
        return "long";
    }

    public String getOutType() {
        return "java.lang.String";
    }

    public Category[] getCategories() {
        return new Category[]{Category.general};
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("WeightedStringsFromCSV", "Create a sampler of strings from the given CSV file. The CSV file must have plain CSV headers\nas its first line.\n@param valueColumn The name of the value column to be sampled\n@param weightColumn The name of the weight column, which must be parsable as a double\n@param filenames One or more file names which will be read in to the sampler buffer\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("valueColumn", "java.lang.String");
                        this.put("weightColumn", "java.lang.String");
                        this.put("filenames", "java.lang.String[]...");
                    }
                }, (List)new ArrayList<List<String>>(){}));
            }
        };
    }
}

