/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadString
implements LongFunction<String> {
    private final String name;
    private final LongFunction<Object> nameFunc;
    private final String defaultValue;

    @Example(value={"LoadString('foo','examplevalue')", "for the current thread, load a String value from the named variable."})
    public LoadString(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = "";
    }

    @Example(value={"LoadString('foo','examplevalue')", "for the current thread, load a String value from the named variable, or the default value if the named variable is not defined."})
    public LoadString(String name, String defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"LoadString(NumberNameToString(),'examplevalue')", "for the current thread, load a String value from the named variable, or the default value if the named variable is not defined."})
    public LoadString(LongFunction<Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = "";
    }

    @Example(value={"LoadString(NumberNameToString(),'examplevalue')", "for the current thread, load a String value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadString(LongFunction<Object> nameFunc, String defaultValue) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public String apply(long value) {
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(value)) : this.name;
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        Object loaded = map.getOrDefault(varname, this.defaultValue);
        return (String)loaded;
    }
}

