package io.virtdata.libbasics.shared.from_string.to_unset;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.api.VALUE;

import java.util.function.Function;

@Categories(Category.nulls)
@ThreadSafeMapper
public class UnsetIfStringNe implements Function<String,Object> {

    private String compareto;

    public UnsetIfStringNe(String compareto) {
        this.compareto = compareto;
    }

    @Override
    public Object apply(String s) {
        if (s!=null && (!s.equals(compareto))) {
            return VALUE.unset;
        }
        if (s!=null) {
            return s;
        }
        throw new RuntimeException("This function is not able to take null values as input. If you need to do that, consider using NullIfNullOrEmpty()");
    }
}
