/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_object;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_double.HashedDoubleRange;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.distributions})
@ThreadSafeMapper
public class CoinFunc
implements Function<Long, Object> {
    private final double threshold;
    private final LongFunction<? extends Object> first;
    private final LongFunction<? extends Object> second;
    private final HashedDoubleRange cointoss = new HashedDoubleRange(0.0, 1.0);

    @Example(value={"CoinFunc(0.15,NumberNameToString(),Combinations('A:1:B:23'))", "use the first function 15% of the time"})
    public CoinFunc(double threshold, LongFunction<? extends Object> first, LongFunction<? extends Object> second) {
        this.threshold = threshold;
        this.first = first;
        this.second = second;
    }

    public CoinFunc(double threshold, LongFunction<? extends Object> first, Function<Long, ? extends Object> second) {
        this.threshold = threshold;
        this.first = first;
        this.second = second::apply;
    }

    public CoinFunc(double threshold, LongFunction<? extends Object> first, LongUnaryOperator second) {
        this.threshold = threshold;
        this.first = first::apply;
        this.second = second::applyAsLong;
    }

    public CoinFunc(double threshold, Function<Long, ? extends Object> first, Function<Long, ? extends Object> second) {
        this.threshold = threshold;
        this.first = first::apply;
        this.second = second::apply;
    }

    public CoinFunc(double threshold, Function<Long, ? extends Object> first, LongFunction<? extends Object> second) {
        this.threshold = threshold;
        this.first = first::apply;
        this.second = second;
    }

    public CoinFunc(double threshold, Function<Long, ? extends Object> first, LongUnaryOperator second) {
        this.threshold = threshold;
        this.first = first::apply;
        this.second = second::applyAsLong;
    }

    public CoinFunc(double threshold, LongUnaryOperator first, Function<Long, ? extends Object> second) {
        this.threshold = threshold;
        this.first = first::applyAsLong;
        this.second = second::apply;
    }

    public CoinFunc(double threshold, LongUnaryOperator first, LongFunction<? extends Object> second) {
        this.threshold = threshold;
        this.first = first::applyAsLong;
        this.second = second::apply;
    }

    public CoinFunc(double threshold, LongUnaryOperator first, LongUnaryOperator second) {
        this.threshold = threshold;
        this.first = first::applyAsLong;
        this.second = second::applyAsLong;
    }

    @Override
    public Object apply(Long aLong) {
        double unfaircoin = this.cointoss.applyAsDouble(aLong);
        Object result = unfaircoin < this.threshold ? this.first.apply(aLong) : this.second.apply(aLong);
        return result;
    }
}

