/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_string.ModuloLineToString;
import io.virtdata.util.ResourceFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class ModuloCSVLineToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(ModuloLineToString.class);
    private List<String> lines = new ArrayList<String>();
    private String filename;

    @Example(value={"ModuloCSVLineToString('data/myfile.csv','lat')", "load values for 'lat' from the CSV file myfile.csv."})
    public ModuloCSVLineToString(String filename, String fieldname) {
        this.filename = filename;
        CSVParser csvp = ResourceFinder.readFileCSV((String)filename, (String[])new String[0]);
        int column = (Integer)csvp.getHeaderMap().get(fieldname);
        for (CSVRecord strings : csvp) {
            this.lines.add(strings.get(column));
        }
    }

    @Override
    public String apply(long input) {
        int itemIdx = (int)(input % (long)this.lines.size()) % Integer.MAX_VALUE;
        String item = this.lines.get(itemIdx);
        return item;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }
}

