/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadFloat
implements LongFunction<Float> {
    private final String name;
    private final LongFunction<Object> nameFunc;
    private final float defaultValue;

    @Example(value={"LoadFloat('foo')", "for the current thread, load a float value from the named variable."})
    public LoadFloat(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = 0.0f;
    }

    @Example(value={"LoadFloat('foo',23F)", "for the current thread, load a float value from the named variable,or the default value if the named variable is not defined."})
    public LoadFloat(String name, float defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"LoadFloat(NumberNameToString())", "for the current thread, load a float value from the named variable,where the variable name is provided by a function."})
    public LoadFloat(LongFunction<Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = 0.0f;
    }

    @Example(value={"LoadFloat(NumberNameToString(),23F)", "for the current thread, load a float value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadFloat(LongFunction<Object> nameFunc, float defaultValue) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public Float apply(long value) {
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(value)) : this.name;
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        Object loaded = map.getOrDefault(varname, Float.valueOf(this.defaultValue));
        return (Float)loaded;
    }
}

