/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.core.lfsrs;

import io.virtdata.util.VirtDataResources;
import java.util.List;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaShift {
    private static final Logger logger = LoggerFactory.getLogger(MetaShift.class);
    private static int[] msbs = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};

    public static Func forSizeAndBank(long size, int selector) {
        GaloisData data = Masks.forPeriodAndBank(size, selector);
        return new Func(data);
    }

    public static Func forSizeAndModulo(long size, int modulo) {
        GaloisData data = Masks.forPeriodAndBankModulo(size, modulo);
        return new Func(data);
    }

    public static long maskForMsb(long period) {
        int lsbwidth = MetaShift.getMsbPosition(period);
        long register = 1L;
        for (int i = 0; i < lsbwidth - 1; ++i) {
            register |= register << 1;
        }
        return register;
    }

    public static int getMsbPosition(long value) {
        if (value < 0L) {
            throw new RuntimeException("Only values between 1 and 9223372036854775807 are supported, and you tried to get the MSB position for value " + value + " or possible overflowed to a negative value.");
        }
        int r = 0;
        if ((value & 0xFFFFFFFF00000000L) > 0L) {
            r += 32;
            value >>= 32;
        }
        if ((value & 0xFFFF0000L) > 0L) {
            r += 16;
            value >>= 16;
        }
        if ((value & 0xFF00L) > 0L) {
            r += 8;
            value >>= 8;
        }
        if ((value & 0xF0L) > 0L) {
            r += 4;
            value >>= 4;
        }
        return r + msbs[(int)value];
    }

    public static String toBitString(int value) {
        return MetaShift.toBitString(value, 32);
    }

    public static String toBitString(long value) {
        return MetaShift.toBitString(value, 64L);
    }

    public static String toBitString(long value, long len) {
        return String.format("%" + len + "s", Long.toBinaryString(value)).replace(' ', '0');
    }

    public static String toBitString(int value, int len) {
        return String.format("%" + len + "s", Integer.toBinaryString(value)).replace(' ', '0');
    }

    public static class Masks {
        public static GaloisData forPeriodAndBank(long period, int bank) {
            int registerWidth = MetaShift.getMsbPosition(period);
            long[] longs = Masks.masksForBitWidth(registerWidth);
            try {
                return new GaloisData(longs[bank], period, registerWidth, MetaShift.maskForMsb(period));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException("There are only " + longs.length + " items available for a cycle resamplePeriod of " + period);
            }
        }

        public static GaloisData forPeriodAndBankModulo(long period, int bankModulo) {
            int registerWidth = MetaShift.getMsbPosition(period);
            long[] longs = Masks.masksForBitWidth(registerWidth);
            return new GaloisData(longs[bankModulo % longs.length], period, registerWidth, MetaShift.maskForMsb(period));
        }

        public static long[] masksForBitWidth(int registerSize) {
            if (registerSize > 64) {
                throw new RuntimeException("Unable to map LFSR coefficients for registers > 64 bits wide.");
            }
            int availableSize = Math.max(registerSize, 4);
            String maskFileName = String.valueOf(availableSize) + ".txt";
            List lines = VirtDataResources.readDataFileLines((String)("lfsrmasks/" + maskFileName));
            long[] longs = lines.stream().mapToLong(s -> Long.parseLong(s, 16)).toArray();
            return longs;
        }
    }

    public static class Func
    implements LongUnaryOperator {
        public final GaloisData config;
        public final long feedback;
        public final long periodModulo;

        public Func(GaloisData config) {
            this.config = config;
            this.feedback = config.feedback;
            this.periodModulo = config.actualPeriod;
        }

        @Override
        public long applyAsLong(long register) {
            long lsb = register & 1L;
            register >>= 1;
            return register ^= -lsb & this.feedback;
        }

        public String toString() {
            return this.config.toString();
        }
    }

    public static class GaloisData {
        public final long feedback;
        public final long resamplePeriod;
        public final long width;
        public final long mask;
        public final int actualPeriod;

        public GaloisData(long feedback, long resamplePeriod, long width, long mask) {
            this.feedback = feedback;
            this.resamplePeriod = resamplePeriod;
            this.width = width;
            this.mask = mask;
            this.actualPeriod = (1 << (int)width) - 1;
        }

        public GaloisData withOffset(long offset) {
            return new GaloisData(this.feedback, this.resamplePeriod, this.width, this.mask);
        }

        public String toString() {
            return "(feedback,resample,width,mask=(" + this.feedback + "," + this.resamplePeriod + "," + this.width + "," + this.mask + ")";
        }
    }
}

