// This file is auto-generated.
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class InterpolateAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "Interpolate";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.from_long.to_long";
  }

  public String getClassJavadoc() {
    return "Return a value along an interpolation curve. This allows you to sketch a basic\n"
            + "density curve and describe it simply with just a few values. The number of values\n"
            + "provided determines the resolution of the internal lookup table that is used for\n"
            + "interpolation. The first value is always the 0.0 anchoring point on the unit interval.\n"
            + "The last value is always the 1.0 anchoring point on the unit interval. This means\n"
            + "that in order to subdivide the density curve in an interesting way, you need to provide\n"
            + "a few more values in between them. Providing two values simply provides a uniform\n"
            + "sample between a minimum and maximum value.\n"
            + "\n"
            + "The input range of this function is, as many of the other functions in this library,\n"
            + "based on the valid range of positive long values, between 0L and Long.MAX_VALUE inclusive.\n"
            + "This means that if you want to combine interpolation on this curve with the effect of\n"
            + "pseudo-random sampling, you need to put a hash function ahead of it in the flow.\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "long";
  }

  public Category[] getCategories() {
    return new Category[] {  };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("Interpolate", "", 
            new LinkedHashMap<String, String>() {{
              put("values","double[]...");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("Interpolate(0.0d,100.0d)");
                add("return a uniform long value between 0L and 100L");
              }});
              add(new ArrayList<String>() {{
                add("Interpolate(0.0d,90.0d,95.0d,98.0d,100.0d)");
                add("return a weighted long value where the first second and third quartiles are 90.0D, 95.0D, and 98.0D");
              }});
            }}
          ));
        }};
  }
}
