/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_double.HashedDoubleRange;
import java.util.ArrayList;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class WeightedStrings
implements LongFunction<String> {
    private final String valuesAndWeights;
    private double[] unitWeights;
    private double[] cumulativeWeights;
    private HashedDoubleRange unitRange = new HashedDoubleRange(0.0, 1.0);
    private String[] values;

    public WeightedStrings(String valuesAndWeights) {
        this.valuesAndWeights = valuesAndWeights;
        this.parseWeights();
    }

    private void parseWeights() {
        String[] pairs = this.valuesAndWeights.split("[;,]");
        if (pairs.length == 0) {
            throw new RuntimeException("No pairs were found. They must be separated by ';'");
        }
        this.values = new String[pairs.length];
        ArrayList<Double> parsedWeights = new ArrayList<Double>();
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i].split(":", 2);
            if (pair.length == 2) {
                parsedWeights.add(Double.valueOf(pair[1].trim()));
            } else {
                parsedWeights.add(1.0);
            }
            this.values[i] = pair[0].trim();
        }
        double total = parsedWeights.stream().mapToDouble(f -> f).sum();
        this.unitWeights = parsedWeights.stream().mapToDouble(f -> f / total).toArray();
        this.cumulativeWeights = new double[this.unitWeights.length];
        double cumulative = 0.0;
        for (int i = 0; i < this.unitWeights.length; ++i) {
            this.cumulativeWeights[i] = cumulative += this.unitWeights[i];
        }
    }

    @Override
    public String apply(long value) {
        double sampledUnit = this.unitRange.applyAsDouble(value);
        for (int i = 0; i < this.cumulativeWeights.length; ++i) {
            if (!(sampledUnit < this.cumulativeWeights[i])) continue;
            return this.values[i];
        }
        throw new RuntimeException("sampled value '" + sampledUnit + "' was not below final cumulative weight: " + this.cumulativeWeights[this.cumulativeWeights.length - 1]);
    }
}

