/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_time_types;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.DateTimeFormats;
import java.util.UUID;
import java.util.function.LongFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class ToEpochTimeUUID
implements LongFunction<UUID> {
    private final long node;
    private final long clock;
    private final long baseEpochMillis;

    @Example(value={"ToEpochTimeUUID()", "basetime 0, computed node data, empty clock data"})
    public ToEpochTimeUUID() {
        this.node = 0L;
        this.clock = 0L;
        this.baseEpochMillis = 0L;
    }

    @Example(value={"ToEpochTimeUUID(5234)", "basetime 0, specified node data (5234), empty clock data"})
    public ToEpochTimeUUID(long node) {
        this.node = node;
        this.clock = 0L;
        this.baseEpochMillis = 0L;
    }

    @Example(value={"ToEpochTimeUUID(31,337)", "basetime 0, specified node data (31) and clock data (337)"})
    public ToEpochTimeUUID(long node, long clock) {
        this.node = node;
        this.clock = clock;
        this.baseEpochMillis = 0L;
    }

    @Example(value={"ToEpochTimeUUID('2017-01-01T23:59:59')", "specified basetime, computed node data, empty clock data"})
    public ToEpochTimeUUID(String baseSpec) {
        this.node = 0L;
        this.clock = 0L;
        this.baseEpochMillis = DateTimeFormats.parseEpochTimeToGregorianMillis(baseSpec);
    }

    @Example(value={"ToEpochTimeUUID('2012',12345)", "basetime at start if 2012, with node data 12345, empty clock data"})
    public ToEpochTimeUUID(String baseSpec, long node) {
        this.node = node;
        this.clock = 0L;
        this.baseEpochMillis = DateTimeFormats.parseEpochTimeToGregorianMillis(baseSpec);
    }

    @Example(value={"ToEpochTimeUUID('20171231T1015.243',123,456)", "ms basetime, specified node and clock data"})
    public ToEpochTimeUUID(String baseSpec, long node, long clock) {
        this.node = node;
        this.clock = clock;
        this.baseEpochMillis = DateTimeFormats.parseEpochTimeToGregorianMillis(baseSpec);
    }

    private static long msbBitsFor(long timeClicks) {
        return 0x1000L | (0xFFF000000000000L & timeClicks) >>> 48 | (0xFFFF00000000L & timeClicks) >>> 16 | (0xFFFFFFFFL & timeClicks) << 32;
    }

    private static long lsbBitsFor(long node, long clock) {
        return (clock & 0x3FFFL) << 48 | Long.MIN_VALUE | node;
    }

    private static long timeTicksFor(long epochMillis) {
        Duration duration = new Duration((ReadableInstant)DateTimeFormats.gregorianCalendarStart, (ReadableInstant)new DateTime(epochMillis, DateTimeZone.UTC));
        return duration.getMillis() * 10000L;
    }

    @Override
    public UUID apply(long timeTicks) {
        return new UUID(ToEpochTimeUUID.msbBitsFor(ToEpochTimeUUID.timeTicksFor(timeTicks + this.baseEpochMillis)), ToEpochTimeUUID.lsbBitsFor(this.node, this.clock));
    }
}

