/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.HashSet;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class Set
implements LongFunction<java.util.Set<Object>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> valueFunc;

    @Example(value={"Set(HashRange(3,7),Add(15L))", "create a set between 3 and 7 elements of Long values"})
    public Set(LongToIntFunction sizeFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.valueFunc = valueFunc;
    }

    @Override
    public java.util.Set<Object> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashSet<Object> set = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            set.add(this.valueFunc.apply(value + (long)i));
        }
        return set;
    }
}

