/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class Combinations
implements LongFunction<String> {
    private final char[][] charsets;
    private final long[] modulo;

    @Examples(value={@Example(value={"Combinations('A-Z;A-Z')", "a two digit alphanumeric code. Wraps at 26^2"}), @Example(value={"Combinations('0-9A-F')", "a single hexadecimal digit"}), @Example(value={"Combinations('0123456789ABCDEF')", "a single hexadecimal digit"}), @Example(value={"Combinations('0-9A-F;0-9A-F;0-9A-F;0-9A-F;')", "two bytes of hexadecimal"}), @Example(value={"Combinations('A-9')", "upper case alphanumeric"})})
    public Combinations(String string) {
        this.charsets = this.parseSpec(string);
        this.modulo = this.computeRadixFactors(this.charsets);
    }

    @Override
    public String apply(long l) {
        CharBuffer charBuffer = CharBuffer.allocate(this.charsets.length);
        for (int i = 0; i < this.charsets.length; ++i) {
            int n = (int)(l / this.modulo[i] % Integer.MAX_VALUE);
            l %= this.modulo[i];
            int n2 = n % this.charsets[i].length;
            char c = this.charsets[i][n2];
            charBuffer.put(i, c);
        }
        return charBuffer.toString();
    }

    private long[] computeRadixFactors(char[][] cArray) {
        long l = 1L;
        long[] lArray = new long[cArray.length];
        for (int i = cArray.length - 1; i >= 0; --i) {
            lArray[i] = l;
            l = Math.multiplyExact(l, cArray[i].length);
        }
        return lArray;
    }

    private char[][] parseSpec(String string) {
        String[] stringArray = string.split("[,;]");
        char[][] cArrayArray = new char[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            char[] cArray = this.rangeFor(stringArray[i]);
            cArrayArray[i] = cArray;
        }
        return cArrayArray;
    }

    private char[] rangeFor(String string) {
        Object object;
        ArrayList<Character> arrayList = new ArrayList<Character>();
        int n = 0;
        while (n < string.length()) {
            if (string.length() > n + 2 && string.substring(n + 1, n + 2).equals("-")) {
                object = this.rangeFor(string.substring(n, n + 1), string.substring(n + 2, n + 3));
                arrayList.addAll((Collection<Character>)object);
                n += 3;
                continue;
            }
            arrayList.add(Character.valueOf(string.substring(n, n + 1).charAt(0)));
            ++n;
        }
        object = new char[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = ((Character)arrayList.get(i)).charValue();
        }
        return object;
    }

    private List<Character> rangeFor(String string, String string2) {
        int n = string.getBytes(StandardCharsets.US_ASCII)[0];
        byte by = string2.getBytes(StandardCharsets.US_ASCII)[0];
        this.assertPrintable(n);
        this.assertPrintable(by);
        this.assertOrder(n, by);
        ArrayList<Character> arrayList = new ArrayList<Character>();
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        for (int i = n; i <= by; ++i) {
            byteBuffer.clear();
            byteBuffer.put(0, (byte)i);
            CharBuffer charBuffer = StandardCharsets.US_ASCII.decode(byteBuffer);
            arrayList.add(Character.valueOf(charBuffer.get(0)));
        }
        return arrayList;
    }

    private void assertOrder(int n, int n2) {
        if (n2 < n) {
            throw new RuntimeException("char '" + (char)n2 + "' (" + n2 + ") occurs after '" + (char)n + "' (" + n + "). Are you sure this is the right spec? (reverse the order)");
        }
    }

    private void assertPrintable(int n) {
        if (n > 126 || n < 32) {
            throw new RuntimeException("ASCII character for code " + n + " is outside the range of printable characters.");
        }
    }
}

