/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class AlphaNumericString
implements LongFunction<String> {
    private static final String AVAILABLE_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private final ThreadLocal<StringBuilder> threadStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
    private final Hash hash = new Hash();
    private final int length;

    public AlphaNumericString(int n) {
        if (n < 0) {
            throw new RuntimeException("AlphaNumericString must have length >= 0");
        }
        this.length = n;
    }

    @Override
    public String apply(long l) {
        long l2 = l;
        StringBuilder stringBuilder = this.threadStringBuilder.get();
        stringBuilder.setLength(0);
        for (int i = 0; i < this.length; ++i) {
            l2 = this.hash.applyAsLong(l2);
            int n = (int)(l2 % (long)AVAILABLE_CHARS.length());
            stringBuilder.append(AVAILABLE_CHARS.charAt(n));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "AlphaNumericString(length=" + this.length + ")";
    }
}

