/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadInteger
implements LongToIntFunction {
    private final String name;
    private final LongFunction<Object> nameFunc;
    private final int defaultValue;

    @Example(value={"LoadInteger('foo')", "for the current thread, load an integer value from the named variable."})
    public LoadInteger(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0;
    }

    @Example(value={"LoadInteger('foo',42)", "for the current thread, load an integer value from the named variable, or the default value if the named variable is not defined."})
    public LoadInteger(String string, int n) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = n;
    }

    @Example(value={"LoadInteger(NumberNameToString())", "for the current thread, load an integer value from the named variable,where the variable name is provided by a function."})
    public LoadInteger(LongFunction<Object> longFunction) {
        this.name = null;
        this.nameFunc = longFunction;
        this.defaultValue = 0;
    }

    @Example(value={"LoadInteger(NumberNameToString(),42)", "for the current thread, load an integer value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadInteger(LongFunction<Object> longFunction, int n) {
        this.name = null;
        this.nameFunc = longFunction;
        this.defaultValue = n;
    }

    @Override
    public int applyAsInt(long l) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(l)) : this.name;
        Object object = hashMap.getOrDefault(string, this.defaultValue);
        return (Integer)object;
    }
}

