/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadDouble
implements LongToDoubleFunction {
    private final String name;
    private final LongFunction<Object> nameFunc;
    private final double defaultValue;

    @Example(value={"LoadDouble('foo')", "for the current thread, load a double value from the named variable."})
    public LoadDouble(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0.0;
    }

    @Example(value={"LoadDouble('foo',23D)", "for the current thread, load a double value from the named variable,or the default value if the named variable is not defined."})
    public LoadDouble(String string, double d) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = d;
    }

    @Example(value={"LoadDouble(NumberNameToString())", "for the current thread, load a double value from the named variable, where the variable name is provided by a function."})
    public LoadDouble(LongFunction<Object> longFunction) {
        this.name = null;
        this.nameFunc = longFunction;
        this.defaultValue = 0.0;
    }

    @Example(value={"LoadDouble(NumberNameToString(),23D)", "for the current thread, load a double value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadDouble(LongFunction<Object> longFunction, double d) {
        this.name = null;
        this.nameFunc = longFunction;
        this.defaultValue = d;
    }

    @Override
    public double applyAsDouble(long l) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(l)) : this.name;
        Object object = hashMap.getOrDefault(string, this.defaultValue);
        return (Double)object;
    }
}

