/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.Arrays;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class FieldExtractor
implements Function<String, String> {
    private static final Logger logger = LoggerFactory.getLogger(FieldExtractor.class);
    private final String fields;
    private final String splitDelim;
    private final String printDelim;
    private final int maxIdx;
    private int[] indexes;
    private ThreadLocal<StringBuilder> tlsb = ThreadLocal.withInitial(StringBuilder::new);

    @Example(value={"FieldExtractor('|,2,16')", "extract fields 2 and 16 from the input data with '|' as the delimiter"})
    public FieldExtractor(String string) {
        this.fields = string;
        String[] stringArray = string.split(",");
        this.printDelim = stringArray[0];
        this.splitDelim = "\\" + stringArray[0];
        this.indexes = new int[stringArray.length - 1];
        for (int i = 1; i <= this.indexes.length; ++i) {
            this.indexes[i - 1] = Integer.valueOf(stringArray[i].trim()) - 1;
        }
        this.maxIdx = Arrays.stream(this.indexes).max().orElse(-1);
    }

    private int[] initIndexes(String string) {
        return this.indexes;
    }

    @Override
    public String apply(String string) {
        String[] stringArray = string.split(this.splitDelim);
        if (stringArray.length < this.maxIdx) {
            logger.warn("Short read on line, indexes: " + Arrays.toString(this.indexes) + ", line:" + string + ", returning 'ERROR-UNDERRUN'");
            return "ERROR-UNDERRUN in FieldExtractor";
        }
        StringBuilder stringBuilder = this.tlsb.get();
        stringBuilder.setLength(0);
        for (int n : this.indexes) {
            stringBuilder.append(stringArray[n]).append(this.printDelim);
        }
        stringBuilder.setLength(stringBuilder.length() - this.printDelim.length());
        return stringBuilder.toString();
    }
}

