/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_int;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;

@Categories(value={Category.state})
@ThreadSafeMapper
public class Load
implements IntUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final int defaultValue;

    @Example(value={"Load('foo')", "for the current thread, load an int value from the named variable"})
    public Load(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0;
    }

    @Example(value={"Load('foo',42)", "for the current thread, load an int value from the named variable, or return the default value if it is undefined."})
    public Load(String string, int n) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = n;
    }

    @Example(value={"Load(NumberNameToString())", "for the current thread, load an int value from the named variable, where the variable name is provided by a function."})
    public Load(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = 0;
    }

    @Example(value={"Load(NumberNameToString(),42)", "for the current thread, load an int value from the named variable, where the variable name is provided by a function, or the default value if the named variable is undefined."})
    public Load(Function<Object, Object> function, int n) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = n;
    }

    @Override
    public int applyAsInt(int n) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(n)) : this.name;
        Object object = hashMap.getOrDefault(string, this.defaultValue);
        return (Integer)object;
    }
}

