/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_double.to_double;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class Load
implements DoubleUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final double defaultValue;

    @Example(value={"Load('foo')", "for the current thread, load a double value from the named variable"})
    public Load(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0.0;
    }

    @Example(value={"Load('foo',432.0D)", "for the current thread, load a double value from the named variable, or the defaultvalue if it is not yet defined."})
    public Load(String string, double d) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = d;
    }

    @Example(value={"Load(NumberNameToString())", "for the current thread, load a double value from the named variable, where the variablename is provided by a function."})
    public Load(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = 0.0;
    }

    @Example(value={"Load(NumberNameToString(),1234.5D)", "for the current thread, load a double value from the named variable, where the variablename is provided by a function, or the default value if the named value is not yet defined."})
    public Load(Function<Object, Object> function, double d) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = d;
    }

    @Override
    public double applyAsDouble(double d) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(d)) : this.name;
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        Object object = hashMap.getOrDefault(string, this.defaultValue);
        return (Double)object;
    }
}

