/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class Clamp
implements LongUnaryOperator {
    private final long min;
    private final long max;

    @Example(value={"Clamp(4L,400L)", "clamp the output values in the range [4L,400L], inclusive"})
    public Clamp(long l, long l2) {
        this.min = l;
        this.max = l2;
    }

    @Override
    public long applyAsLong(long l) {
        return Long.min(this.max, Long.max(this.min, l));
    }
}

