/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
@Categories(value={Category.state})
public class Save
implements LongUnaryOperator {
    private final String name;
    private final LongFunction<Object> nameFunc;

    @Example(value={"Save('foo')", "for the current thread, save the input object value to the named variable"})
    public Save(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"Save(NumberNameToString())", "for the current thread, save the current input object value to the named variable,where the variable name is provided by a function."})
    public Save(LongFunction<Object> longFunction) {
        this.name = null;
        this.nameFunc = longFunction;
    }

    @Override
    public long applyAsLong(long l) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(l)) : this.name;
        hashMap.put(string, l);
        return l;
    }
}

