/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.core.lfsrs;

import io.virtdata.util.VirtDataResources;
import java.util.List;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaShift {
    private static final Logger logger = LoggerFactory.getLogger(MetaShift.class);
    private static int[] msbs = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};

    public static Func forSizeAndBank(long l, int n) {
        GaloisData galoisData = Masks.forPeriodAndBank(l, n);
        return new Func(galoisData);
    }

    public static Func forSizeAndModulo(long l, int n) {
        GaloisData galoisData = Masks.forPeriodAndBankModulo(l, n);
        return new Func(galoisData);
    }

    public static long maskForMsb(long l) {
        int n = MetaShift.getMsbPosition(l);
        long l2 = 1L;
        for (int i = 0; i < n - 1; ++i) {
            l2 |= l2 << 1;
        }
        return l2;
    }

    public static int getMsbPosition(long l) {
        if (l < 0L) {
            throw new RuntimeException("Only values between 1 and 9223372036854775807 are supported, and you tried to get the MSB position for value " + l + " or possible overflowed to a negative value.");
        }
        int n = 0;
        if ((l & 0xFFFFFFFF00000000L) > 0L) {
            n += 32;
            l >>= 32;
        }
        if ((l & 0xFFFF0000L) > 0L) {
            n += 16;
            l >>= 16;
        }
        if ((l & 0xFF00L) > 0L) {
            n += 8;
            l >>= 8;
        }
        if ((l & 0xF0L) > 0L) {
            n += 4;
            l >>= 4;
        }
        return n + msbs[(int)l];
    }

    public static String toBitString(int n) {
        return MetaShift.toBitString(n, 32);
    }

    public static String toBitString(long l) {
        return MetaShift.toBitString(l, 64L);
    }

    public static String toBitString(long l, long l2) {
        return String.format("%" + l2 + "s", Long.toBinaryString(l)).replace(' ', '0');
    }

    public static String toBitString(int n, int n2) {
        return String.format("%" + n2 + "s", Integer.toBinaryString(n)).replace(' ', '0');
    }

    public static class Masks {
        public static GaloisData forPeriodAndBank(long l, int n) {
            int n2 = MetaShift.getMsbPosition(l);
            long[] lArray = Masks.masksForBitWidth(n2);
            try {
                return new GaloisData(lArray[n], l, n2, MetaShift.maskForMsb(l));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new RuntimeException("There are only " + lArray.length + " items available for a cycle resamplePeriod of " + l);
            }
        }

        public static GaloisData forPeriodAndBankModulo(long l, int n) {
            int n2 = MetaShift.getMsbPosition(l);
            long[] lArray = Masks.masksForBitWidth(n2);
            return new GaloisData(lArray[n % lArray.length], l, n2, MetaShift.maskForMsb(l));
        }

        public static long[] masksForBitWidth(int n) {
            if (n > 64) {
                throw new RuntimeException("Unable to map LFSR coefficients for registers > 64 bits wide.");
            }
            int n2 = Math.max(n, 4);
            String string2 = String.valueOf(n2) + ".txt";
            List list = VirtDataResources.readDataFileLines((String)("lfsrmasks/" + string2));
            long[] lArray = list.stream().mapToLong(string -> Long.parseLong(string, 16)).toArray();
            return lArray;
        }
    }

    public static class Func
    implements LongUnaryOperator {
        public final GaloisData config;
        public final long feedback;
        public final long periodModulo;

        public Func(GaloisData galoisData) {
            this.config = galoisData;
            this.feedback = galoisData.feedback;
            this.periodModulo = galoisData.actualPeriod;
        }

        @Override
        public long applyAsLong(long l) {
            long l2 = l & 1L;
            l >>= 1;
            return l ^= -l2 & this.feedback;
        }

        public String toString() {
            return this.config.toString();
        }
    }

    public static class GaloisData {
        public final long feedback;
        public final long resamplePeriod;
        public final long width;
        public final long mask;
        public final int actualPeriod;

        public GaloisData(long l, long l2, long l3, long l4) {
            this.feedback = l;
            this.resamplePeriod = l2;
            this.width = l3;
            this.mask = l4;
            this.actualPeriod = (1 << (int)l3) - 1;
        }

        public GaloisData withOffset(long l) {
            return new GaloisData(this.feedback, this.resamplePeriod, this.width, this.mask);
        }

        public String toString() {
            return "(feedback,resample,width,mask=(" + this.feedback + "," + this.resamplePeriod + "," + this.width + "," + this.mask + ")";
        }
    }
}

