/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_int.HashRange;
import io.virtdata.util.VirtDataResources;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class HashedFileExtractToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(HashedFileExtractToString.class);
    private static CharBuffer fileDataImage = null;
    private final HashRange sizeRange;
    private final HashRange positionRange;
    private int minsize;
    private int maxsize;
    private final String fileName;

    @Example(value={"HashedFileExtractToString('data/adventures.txt',100,200)", "return a fragment from adventures.txt between 100 and 200 characters long"})
    public HashedFileExtractToString(String string, int n, int n2) {
        this.fileName = string;
        this.minsize = n;
        this.maxsize = n2;
        this.loadData();
        this.sizeRange = new HashRange(n, n2);
        this.positionRange = new HashRange(1, fileDataImage.limit() - n2 - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadData() {
        if (fileDataImage != null) return;
        Class<HashedFileExtractToString> clazz = HashedFileExtractToString.class;
        synchronized (HashedFileExtractToString.class) {
            CharBuffer charBuffer;
            if (fileDataImage != null) return;
            fileDataImage = charBuffer = VirtDataResources.readDataFileToCharBuffer((String)this.fileName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String apply(long l) {
        int n = this.positionRange.applyAsInt(l);
        int n2 = this.sizeRange.applyAsInt(l);
        String string = null;
        try {
            string = fileDataImage.subSequence(n, n + n2).toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.minsize + ":" + this.maxsize;
    }
}

