/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_double;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class Interpolate
implements LongToDoubleFunction {
    private final double scale;
    private final double[] lut;
    private static final double maxLongAsDouble = 9.223372036854776E18;

    @Examples(value={@Example(value={"Interpolate(0.0d,100.0d)", "return a uniform double value between 0.0d and 100.0d"}), @Example(value={"Interpolate(0.0d,90.0d,95.0d,98.0d,100.0d)", "return a weighted double value where the first second and third quartiles are 90.0D, 95.0D, and 98.0D"})})
    public Interpolate(double ... dArray) {
        double[] dArray2 = new double[dArray.length + 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        dArray2[dArray2.length - 1] = dArray2[dArray2.length - 2];
        this.scale = dArray.length - 1;
        this.lut = dArray2;
    }

    @Override
    public double applyAsDouble(long l) {
        long l2 = l;
        double d = (double)l / 9.223372036854776E18 * this.scale;
        int n = (int)d;
        double d2 = d - (double)((long)d);
        double d3 = this.lut[n] * (1.0 - d2);
        double d4 = this.lut[n + 1] * d2;
        double d5 = d3 + d4;
        return d5;
    }
}

