/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_time_types.joda;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_time_types.joda.Timezones;
import java.util.function.LongUnaryOperator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class ToMillisAtStartOfMinute
implements LongUnaryOperator {
    private final DateTimeZone tz;

    @Example(value={"ToMillisAtStartOfMinute()", "return millisecond epoch time of the start of the minute of the provided millisecond epoch time, assuming UTC"})
    public ToMillisAtStartOfMinute() {
        this(DateTimeZone.UTC.getID());
    }

    @Example(value={"ToMillisAtStartOfMinute('America/Chicago')", "return millisecond epoch time of the start of the minute of the provided millisecond epoch time, using timezone America/Chicago"})
    public ToMillisAtStartOfMinute(String string) {
        this.tz = Timezones.forId(string);
    }

    @Override
    public long applyAsLong(long l) {
        return new DateTime(l, this.tz).withMillisOfSecond(0).withSecondOfMinute(0).getMillis();
    }
}

