// This file is auto-generated.
package io.virtdata.libbasics.shared.functionadapters;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class FlowAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "Flow";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.functionadapters";
  }

  public String getClassJavadoc() {
    return "<p>Combine functions into one.</p>\n"
            + "\n"
            + "<p>This function allows you to combine multiple other functions into one. This is often useful\n"
            + "for constructing more sophisticated recipes, when you don't have the ability to use\n"
            + "control flow or non-functional forms.</p>\n"
            + "\n"
            + "<p>The functions will be stitched together using the same logic that VirtData uses when\n"
            + "combining flows outside functions. That said, if the functions selected are not the right ones,\n"
            + "then it is possible to end up with the wrong data type at the end. To remedy this, be sure\n"
            + "to add input and output qualifiers, like <code>long-&gt;</code> or <code>-&gt;String</code> where\n"
            + "appropriate, to ensure that VirtData selects the right functions within the flow.</p>\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.lang.Object";
  }

  public Category[] getCategories() {
    return new Category[] { Category.conversion };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("Flow", "", 
            new LinkedHashMap<String, String>() {{
              put("funcs","java.lang.Object[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
