/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongFunction;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class DirectoryLines
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryLines.class);
    private final Pattern namePattern;
    private final String basepath;
    private final List<Path> allFiles;
    private Iterator<String> stringIterator;
    private Iterator<Path> pathIterator;

    @Example(value={"DirectoryLines('/var/tmp/bardata', '.*')", "load every line from every file in /var/tmp/bardata"})
    public DirectoryLines(String string, String string2) {
        this.basepath = string;
        this.namePattern = Pattern.compile(string2);
        this.allFiles = this.getAllFiles();
        if (this.allFiles.size() == 0) {
            throw new RuntimeException("Loaded zero files from " + string + ", full path:" + Paths.get(string, new String[0]).getFileName());
        }
        this.pathIterator = this.allFiles.iterator();
        try {
            this.stringIterator = Files.readAllLines(this.pathIterator.next()).iterator();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public synchronized String apply(long l) {
        while (!this.stringIterator.hasNext()) {
            if (this.pathIterator.hasNext()) {
                Path path = this.pathIterator.next();
                try {
                    this.stringIterator = Files.readAllLines(path).iterator();
                    continue;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            logger.debug("Resetting path iterator after exhausting input.");
            this.pathIterator = this.allFiles.iterator();
        }
        return this.stringIterator.next();
    }

    private List<Path> getAllFiles() {
        logger.debug("Loading file paths from " + this.basepath);
        HashSet<FileVisitOption> hashSet = new HashSet<FileVisitOption>();
        hashSet.add(FileVisitOption.FOLLOW_LINKS);
        FileList fileList = new FileList(this.namePattern);
        try {
            Files.walkFileTree(Paths.get(this.basepath, new String[0]), hashSet, 10, fileList);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        logger.debug("File reader: " + fileList.toString() + " in path: " + Paths.get(this.basepath, new String[0]).getFileName());
        fileList.paths.sort(Path::compareTo);
        return fileList.paths;
    }

    private static class FileList
    implements FileVisitor<Path> {
        public final Pattern namePattern;
        public int seen;
        public int kept;
        public List<Path> paths = new ArrayList<Path>();

        private FileList(Pattern pattern) {
            this.namePattern = pattern;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            ++this.seen;
            if (path.toString().matches(this.namePattern.pattern())) {
                this.paths.add(path);
                ++this.kept;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            logger.warn("Error traversing file: " + path + ":" + iOException);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public String toString() {
            return this.kept + "/" + this.seen + " files with pattern '" + this.namePattern + "'";
        }
    }
}

