/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class Swap
implements LongUnaryOperator {
    private final String name;
    private final LongFunction<String> nameGen;
    private final long defaultValue;

    @Example(value={"Swap('foo')", "for the current thread, swap the input value with the named variable and returned the named variable."})
    public Swap(String string) {
        this.name = string;
        this.nameGen = null;
        this.defaultValue = 0L;
    }

    @Example(value={"Swap('foo',234L)", "for the current thread, swap the input value with the named variable and returned the named variable,or the default value if the named variable is not defined."})
    public Swap(String string, long l) {
        this.name = string;
        this.nameGen = null;
        this.defaultValue = l;
    }

    @Example(value={"Swap(NumberNameToString())", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function."})
    public Swap(LongFunction<String> longFunction) {
        this.name = null;
        this.nameGen = longFunction;
        this.defaultValue = 0L;
    }

    @Example(value={"Swap(NumberNameToString(), 234L)", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function, or the default value if the named variable is not defined."})
    public Swap(LongFunction<String> longFunction, long l) {
        this.name = null;
        this.nameGen = longFunction;
        this.defaultValue = l;
    }

    @Override
    public long applyAsLong(long l) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameGen != null ? this.nameGen.apply(l) : this.name;
        long l2 = hashMap.containsKey(string) ? (Long)hashMap.get(string) : this.defaultValue;
        hashMap.put(string, l);
        return l2;
    }
}

