/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_string.ModuloLineToString;
import io.virtdata.util.VirtDataResources;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class ModuloCSVLineToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(ModuloLineToString.class);
    private List<String> lines = new ArrayList<String>();
    private String filename;

    @Example(value={"ModuloCSVLineToString('data/myfile.csv','lat')", "load values for 'lat' from the CSV file myfile.csv."})
    public ModuloCSVLineToString(String string, String string2) {
        this.filename = string;
        CSVParser cSVParser = VirtDataResources.readFileCSV((String)string, (String[])new String[0]);
        int n = (Integer)cSVParser.getHeaderMap().get(string2);
        for (CSVRecord cSVRecord : cSVParser) {
            this.lines.add(cSVRecord.get(n));
        }
    }

    @Override
    public String apply(long l) {
        int n = (int)(l % (long)this.lines.size()) % Integer.MAX_VALUE;
        String string = this.lines.get(n);
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }
}

