// This file is auto-generated.
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class TemplateAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "Template";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.from_long.to_string";
  }

  public String getClassJavadoc() {
    return "Creates a template function which will yield a string which fits the template\n"
            + "provided, with all occurrences of <code>{}</code> substituted pair-wise with the\n"
            + "result of the provided functions. The number of <code>{}</code> entries in the template\n"
            + "must strictly match the number of functions or an error will be thrown.\n"
            + "\n"
            + "The objects passed must be functions of any of the following types:\n"
            + "<UL>\n"
            + "    <LI>LongUnaryOperator</LI>\n"
            + "    <LI>IntUnaryOperator</LI>\n"
            + "    <LI>DoubleUnaryOperator</LI>\n"
            + "    <LI>LongFunction</LI>\n"
            + "    <LI>IntFunction</LI>\n"
            + "    <LI>DoubleFunction</LI>\n"
            + "    <LI>Function&lt;Long,?&gt;</LI>\n"
            + "</UL>\n"
            + "\n"
            + "<p>The result of applying the input value to any of these functions is converted to a String\n"
            + "and then stitched together according to the template provided.</p>\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.lang.String";
  }

  public Category[] getCategories() {
    return new Category[] {  };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.lang.Object[]...");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("Template('{}-{}',Add(10),Hash())");
                add("concatenate input+10, '-', and a pseudo-random long");
              }});
            }}
          ));
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("truncate","boolean");
              put("template","java.lang.String");
              put("funcs","java.lang.Object[]...");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("Template(true, '{}-{}', Add(10),Hash())");
                add("throws an error, as the Add(10) function causes a narrowing conversion for a long input");
              }});
            }}
          ));
          add(new DocForFuncCtor("Template", "If an operator is provided, it is used to change the function input value in an additional way before each function.\n"
              + "\n"
              + "@param iterOp   A pre-generation value mapping function\n"
              + "@param template A string template containing <pre>{}</pre> anchors\n"
              + "@param funcs    A varargs length of LongFunctions of any output type\n", 
            new LinkedHashMap<String, String>() {{
              put("iterOp","java.util.function.LongUnaryOperator");
              put("template","java.lang.String");
              put("funcs","java.util.function.LongFunction<?>[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
