/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;

@Categories(value={Category.state})
@ThreadSafeMapper
public class Load
implements LongUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final long defaultValue;

    @Example(value={"Load('foo')", "for the current thread, load a long value from the named variable"})
    public Load(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0L;
    }

    @Example(value={"Load('foo', 423L)", "for the current thread, load a long value from the named variable, or the default value if the variable is not yet defined"})
    public Load(String string, long l) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = l;
    }

    @Example(value={"Load(NumberNameToString())", "for the current thread, load a long value from the named variable, where the variable name is provided by the provided by a function."})
    public Load(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = 0L;
    }

    @Example(value={"Load(NumberNameToString(),22L)", "for the current thread, load a long value from the named variable, where the variable name is provided by the provided by a function, or the default value if the variable is not yet defined"})
    public Load(Function<Object, Object> function, long l) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = l;
    }

    @Override
    public long applyAsLong(long l) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(l)) : this.name;
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        Object object = hashMap.getOrDefault(string, this.defaultValue);
        return (Long)object;
    }
}

