/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_string.Template;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class JoinTemplate
extends Template
implements LongFunction<String> {
    @Example(value={"JoinTemplate('--',NumberNameToString(),NumberNameToString())", "create values like `one--one`, `two-two`, ..."})
    public JoinTemplate(String string, LongFunction<?> ... longFunctionArray) {
        super(JoinTemplate.templateFor("", string, "", longFunctionArray), longFunctionArray);
    }

    @Example(value={"JoinTemplate('{',',','}',NumberNameToString(),LastNames())", "create values like '{one,Farrel}', '{two,Haskell}', ..."})
    public JoinTemplate(String string, String string2, String string3, LongFunction<?> ... longFunctionArray) {
        super(JoinTemplate.templateFor(string, string2, string3, longFunctionArray), longFunctionArray);
    }

    @Example(value={"JoinTemplate(Add(3),'[',';',']',NumberNameToString(),NumberNameToString(),NumberNameToString())", "create values like '[zero;three,six]', '[one;four,seven]', ..."})
    public JoinTemplate(LongUnaryOperator longUnaryOperator, String string, String string2, String string3, LongFunction<?> ... longFunctionArray) {
        super(longUnaryOperator, JoinTemplate.templateFor(string, string2, string3, longFunctionArray), longFunctionArray);
    }

    private static String templateFor(String string, String string2, String string3, LongFunction<?> ... longFunctionArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 0; i < longFunctionArray.length; ++i) {
            stringBuilder.append("{}");
            stringBuilder.append(string2);
        }
        stringBuilder.setLength(stringBuilder.length() - string2.length());
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }
}

