// This file is auto-generated.
package io.virtdata.basicsmappers.from_long.to_string;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.autodoctypes.DocCtorData;
import io.virtdata.autodoctypes.DocForFuncCtor;
import io.virtdata.autodoctypes.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class TemplateAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "Template";
  }

  public String getPackageName() {
    return "io.virtdata.basicsmappers.from_long.to_string";
  }

  public String getClassJavadoc() {
    return "Creates a template function which will yield a string which fits the template\n"
            + "provided, with all occurrences of <pre>{}</pre> substituted pair-wise with the\n"
            + "result of the provided functions. The number of <pre>{}</pre> entries in the template\n"
            + "must strictly match the number of functions or an error will be thrown.\n"
            + "\n"
            + "To provide differing values for similarly defined functions in the list, the input\n"
            + "value used is automatically incremented by one for each function, starting with\n"
            + "the initial input value.\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.lang.String";
  }

  public Category[] getCategories() {
    return new Category[] {  };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.util.function.LongFunction<?>[]...");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("Template('{}-{}',Add(10),Hash())");
                add("concatenate input+10, '-', and a pseudo-random long");
              }});
            }}
          ));
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.util.function.Function<java.lang.Long,?>[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.util.function.LongUnaryOperator[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.util.function.IntUnaryOperator[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.util.function.DoubleUnaryOperator[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.util.function.LongToDoubleFunction[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("Template", "", 
            new LinkedHashMap<String, String>() {{
              put("template","java.lang.String");
              put("funcs","java.util.function.LongToIntFunction[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
          add(new DocForFuncCtor("Template", "If an operator is provided, it is used to change the function input value in an additional way before each function.\n"
              + "\n"
              + "@param iterOp   A pre-generation value mapping function\n"
              + "@param template A string template containing <pre>{}</pre> anchors\n"
              + "@param funcs    A varargs length of LongFunctions of any output type\n", 
            new LinkedHashMap<String, String>() {{
              put("iterOp","java.util.function.LongUnaryOperator");
              put("template","java.lang.String");
              put("funcs","java.util.function.LongFunction<?>[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
