// This file is auto-generated.
package io.virtdata.basicsmappers.from_long.to_time_types;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.autodoctypes.DocCtorData;
import io.virtdata.autodoctypes.DocForFuncCtor;
import io.virtdata.autodoctypes.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class ToEpochTimeUUIDAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "ToEpochTimeUUID";
  }

  public String getPackageName() {
    return "io.virtdata.basicsmappers.from_long.to_time_types";
  }

  public String getClassJavadoc() {
    return "Converts a long UTC timestamp in epoch millis form into a Version 1 TimeUUID\n"
            + "according to <a href=\"https://www.ietf.org/rfc/rfc4122.txt\">RFC 4122</a>.\n"
            + "This means that only one unique value for a timeuuid can be generated for\n"
            + "each epoch milli value, even though version 1 TimeUUIDs can normally represent\n"
            + "up to 10000 distinct values per millisecond. If you need to access this\n"
            + "level of resolution for testing purposes, use {@link ToFinestTimeUUID}\n"
            + "instead. This method is to support simple mapping to natural timestamps\n"
            + "as we often find in the real world.\n"
            + "<p>\n"
            + "For the variants that have a String argument in the constructor, this is\n"
            + "a parsable datetime that is used as the base time for all produced values.\n"
            + "Setting this allows you to set the start of the time range for all timeuuid\n"
            + "values produced. All times are parsed for UTC. All time use ISO date ordering,\n"
            + "meaning that the most significant fields always go before the others.\n"
            + "<p>\n"
            + "The valid formats, in joda specifier form are:\n"
            + "<ol>\n"
            + "<li>yyyy-MM-dd HH:mm:ss.SSSZ, for example: 2015-02-28 23:30:15.223</li>\n"
            + "<li>yyyy-MM-dd HH:mm:ss, for example 2015-02-28 23:30:15</li>\n"
            + "<li>yyyyMMdd'T'HHmmss.SSSZ, for example: 20150228T233015.223</li>\n"
            + "<li>yyyyMMdd'T'HHmmssZ, for example: 20150228T233015</li>\n"
            + "<li>yyyy-MM-dd, for example: 2015-02-28</li>\n"
            + "<li>yyyyMMdd, for example: 20150228</li>\n"
            + "<li>yyyyMM, for example: 201502</li>\n"
            + "<li>yyyy, for example: 2015</li>\n"
            + "</ol>\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.util.UUID";
  }

  public Category[] getCategories() {
    return new Category[] { Category.datetime };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("ToEpochTimeUUID", "Create version 1 timeuuids with a per-host node and empty clock data.\n"
              + "The node and clock components are seeded from network interface data. In this case,\n"
              + "the clock data is not seeded uniquely.\n", 
            new LinkedHashMap<String, String>() {{
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToEpochTimeUUID()");
                add("basetime 0, computed node data, empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToEpochTimeUUID", "Create version 1 timeuuids with a specific static node and empty clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param node a fixture value for testing that replaces node and clock bits\n", 
            new LinkedHashMap<String, String>() {{
              put("node","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToEpochTimeUUID(5234)");
                add("basetime 0, specified node data (5234), empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToEpochTimeUUID", "Create version 1 timeuuids with a specific static node and specific clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param node  a fixture value for testing that replaces node bits\n"
              + "@param clock a fixture value for testing that replaces clock bits\n", 
            new LinkedHashMap<String, String>() {{
              put("node","long");
              put("clock","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToEpochTimeUUID(31,337)");
                add("basetime 0, specified node data (31) and clock data (337)");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToEpochTimeUUID", "Create version 1 timeuuids with a per-host node and empty clock data.\n"
              + "The node and clock components are seeded from network interface data. In this case,\n"
              + "the clock data is not seeded uniquely.\n"
              + "\n"
              + "@param baseSpec - a string specification for the base time value\n", 
            new LinkedHashMap<String, String>() {{
              put("baseSpec","java.lang.String");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToEpochTimeUUID('2017-01-01T23:59:59')");
                add("specified basetime, computed node data, empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToEpochTimeUUID", "Create version 1 timeuuids with a specific static node and empty clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param baseSpec - a string specification for the base time value\n"
              + "@param node     a fixture value for testing that replaces node and clock bits\n", 
            new LinkedHashMap<String, String>() {{
              put("baseSpec","java.lang.String");
              put("node","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToEpochTimeUUID('2012',12345)");
                add("basetime at start if 2012, with node data 12345, empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToEpochTimeUUID", "Create version 1 timeuuids with a specific static node and specific clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param baseSpec - a string specification for the base time value\n"
              + "@param node     a fixture value for testing that replaces node bits\n"
              + "@param clock    a fixture value for testing that replaces clock bits\n", 
            new LinkedHashMap<String, String>() {{
              put("baseSpec","java.lang.String");
              put("node","long");
              put("clock","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToEpochTimeUUID('20171231T1015.243',123,456)");
                add("ms basetime, specified node and clock data");
              }});
            }}
          ));
        }};
  }
}
