/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_long;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class Swap
implements LongUnaryOperator {
    private final String name;
    private final LongFunction<String> nameGen;
    private final long defaultValue;

    @Example(value={"Swap('foo')", "for the current thread, swap the input value with the named variable and returned the named variable."})
    public Swap(String name) {
        this.name = name;
        this.nameGen = null;
        this.defaultValue = 0L;
    }

    @Example(value={"Swap('foo',234L)", "for the current thread, swap the input value with the named variable and returned the named variable,or the default value if the named variable is not defined."})
    public Swap(String name, long defaultValue) {
        this.name = name;
        this.nameGen = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"Swap(NumberNameToString())", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function."})
    public Swap(LongFunction<String> nameFunc) {
        this.name = null;
        this.nameGen = nameFunc;
        this.defaultValue = 0L;
    }

    @Example(value={"Swap(NumberNameToString(), 234L)", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function, or the default value if the named variable is not defined."})
    public Swap(LongFunction<String> nameFunc, long defaultValue) {
        this.name = null;
        this.nameGen = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public long applyAsLong(long input) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameGen != null ? this.nameGen.apply(input) : this.name;
        long output = map.containsKey(varname) ? (Long)map.get(varname) : this.defaultValue;
        map.put(varname, input);
        return output;
    }
}

