/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class Interpolate
implements LongUnaryOperator {
    private final int resolution;
    private final double[] lut;

    @Examples(value={@Example(value={"Interpolate(0.0d,100.0d)", "return a uniform long value between 0L and 100L"}), @Example(value={"Interpolate(0.0d,90.0d,95.0d,98.0d,100.0d)", "return a weighted long value where the first second and third quartiles are 90.0D, 95.0D, and 98.0D"})})
    public Interpolate(double ... value) {
        this(value.length, value);
    }

    public Interpolate(long ... value) {
        double[] doubles = new double[value.length];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = value[i];
        }
        this.resolution = doubles.length;
        this.lut = doubles;
    }

    public Interpolate(int resolution, double[] lut) {
        this.resolution = resolution;
        this.lut = lut;
    }

    @Override
    public long applyAsLong(long input) {
        long value = input;
        double unit = (double)value / 9.223372036854776E18;
        double samplePoint = unit * (double)this.resolution;
        int leftidx = (int)samplePoint;
        double leftPartial = samplePoint - (double)leftidx;
        double leftComponent = this.lut[leftidx] * (1.0 - leftPartial);
        double rightComponent = this.lut[leftidx + 1] * leftPartial;
        double sample = leftComponent + rightComponent;
        return (long)sample;
    }
}

