/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class Combinations
implements LongFunction<String> {
    private final char[][] charsets;
    private final long[] modulo;

    @Examples(value={@Example(value={"Combinations('A-Z;A-Z')", "a two digit alphanumeric code. Wraps at 26^2"}), @Example(value={"Combinations('0-9A-F')", "a single hexadecimal digit"}), @Example(value={"Combinations('0123456789ABCDEF')", "a single hexadecimal digit"}), @Example(value={"Combinations('0-9A-F;0-9A-F;0-9A-F;0-9A-F;')", "two bytes of hexadecimal"}), @Example(value={"Combinations('A-9')", "upper case alphanumeric"})})
    public Combinations(String spec) {
        this.charsets = this.parseSpec(spec);
        this.modulo = this.computeRadixFactors(this.charsets);
    }

    @Override
    public String apply(long value) {
        CharBuffer cb = CharBuffer.allocate(this.charsets.length);
        for (int cs = 0; cs < this.charsets.length; ++cs) {
            int charv = (int)(value / this.modulo[cs]);
            value %= this.modulo[cs];
            int selector = charv % this.charsets[cs].length;
            char c = this.charsets[cs][selector];
            cb.put(cs, c);
        }
        return cb.toString();
    }

    private long[] computeRadixFactors(char[][] charsets) {
        long modulo = 1L;
        long[] m = new long[charsets.length];
        for (int i = charsets.length - 1; i >= 0; --i) {
            m[i] = modulo;
            modulo = Math.multiplyExact(modulo, charsets[i].length);
        }
        return m;
    }

    private char[][] parseSpec(String spec) {
        String[] ranges = spec.split("[,;]");
        char[][] cs = new char[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            char[] range = this.rangeFor(ranges[i]);
            cs[i] = range;
        }
        return cs;
    }

    private char[] rangeFor(String range) {
        ArrayList<Character> chars = new ArrayList<Character>();
        int pos = 0;
        while (pos < range.length()) {
            if (range.length() > pos + 2 && range.substring(pos + 1, pos + 2).equals("-")) {
                List<Character> rangeChars = this.rangeFor(range.substring(pos, pos + 1), range.substring(pos + 2, pos + 3));
                chars.addAll(rangeChars);
                pos += 3;
                continue;
            }
            chars.add(Character.valueOf(range.substring(pos, pos + 1).charAt(0)));
            ++pos;
        }
        char[] charAry = new char[chars.size()];
        for (int i = 0; i < chars.size(); ++i) {
            charAry[i] = ((Character)chars.get(i)).charValue();
        }
        return charAry;
    }

    private List<Character> rangeFor(String startChar, String endChar) {
        int start = startChar.getBytes(StandardCharsets.US_ASCII)[0];
        byte end = endChar.getBytes(StandardCharsets.US_ASCII)[0];
        this.assertPrintable(start);
        this.assertPrintable(end);
        this.assertOrder(start, end);
        ArrayList<Character> chars = new ArrayList<Character>();
        ByteBuffer bb = ByteBuffer.allocate(1);
        for (int i = start; i <= end; ++i) {
            bb.clear();
            bb.put(0, (byte)i);
            CharBuffer decoded = StandardCharsets.US_ASCII.decode(bb);
            chars.add(Character.valueOf(decoded.get(0)));
        }
        return chars;
    }

    private void assertOrder(int start, int end) {
        if (end < start) {
            throw new RuntimeException("char '" + (char)end + "' (" + end + ") occurs after '" + (char)start + "' (" + start + "). Are you sure this is the right spec? (reverse the order)");
        }
    }

    private void assertPrintable(int asciiCode) {
        if (asciiCode > 126 || asciiCode < 32) {
            throw new RuntimeException("ASCII character for code " + asciiCode + " is outside the range of printable characters.");
        }
    }
}

