/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.SharedState;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;

@ThreadSafeMapper
public class SaveFloat
implements UnaryOperator<Float> {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"SaveFloat('foo')", "save the current float value to a named variable in this thread."})
    public SaveFloat(String name) {
        this.name = name;
        this.nameFunc = null;
    }

    @Example(value={"SaveFloat(NumberNameToString())", "save the current float value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveFloat(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
    }

    @Override
    public Float apply(Float operand) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(operand)) : this.name;
        map.put(varname, operand);
        return operand;
    }
}

