/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class LoadDouble
implements LongToDoubleFunction {
    private final String name;
    private final LongFunction<Object> nameFunc;
    private final double defaultValue;

    @Example(value={"LoadDouble('foo')", "for the current thread, load a double value from the named variable."})
    public LoadDouble(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = 0.0;
    }

    @Example(value={"LoadDouble('foo',23D)", "for the current thread, load a double value from the named variable,or the default value if the named variable is not defined."})
    public LoadDouble(String name, double defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"LoadDouble(NumberNameToString())", "for the current thread, load a double value from the named variable, where the variable name is provided by a function."})
    public LoadDouble(LongFunction<Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = 0.0;
    }

    @Example(value={"LoadDouble(NumberNameToString(),23D)", "for the current thread, load a double value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadDouble(LongFunction<Object> nameFunc, double defaultValue) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public double applyAsDouble(long value) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(value)) : this.name;
        Object loaded = map.getOrDefault(varname, this.defaultValue);
        return (Double)loaded;
    }
}

