// This file is auto-generated.
package io.virtdata.libbasics.shared.from_long.to_time_types;

import io.virtdata.annotations.Category;
import io.virtdata.autodoctypes.DocCtorData;
import io.virtdata.autodoctypes.DocForFuncCtor;
import io.virtdata.autodoctypes.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ToFinestTimeUUIDAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "ToFinestTimeUUID";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.from_long.to_time_types";
  }

  public String getClassJavadoc() {
    return "Converts a count of 100ns intervals from 1582 Julian to a Type1 TimeUUID\n"
            + "according to <a href=\"https://www.ietf.org/rfc/rfc4122.txt\">RFC 4122</a>.\n"
            + "This allows you to access the finest unit of resolution for the\n"
            + "purposes of simulating a large set of unique timeuuid values. This offers\n"
            + "10000 times more unique values per ms than {@link ToEpochTimeUUID}.\n"
            + "\n"
            + "For the variants that have a String argument in the constructor, this is\n"
            + "a parsable datetime that is used as the base time for all produced values.\n"
            + "Setting this allows you to set the start of the time range for all timeuuid\n"
            + "values produced. All times are parsed for UTC. All time use ISO date ordering,\n"
            + "meaning that the most significant fields always go before the others.\n"
            + "\n"
            + "The valid formats, in joda specifier form are:\n"
            + "\n"
            + "<ol>\n"
            + "<li>yyyy-MM-dd HH:mm:ss.SSSZ, for example: 2015-02-28 23:30:15.223</li>\n"
            + "<li>yyyy-MM-dd HH:mm:ss, for example 2015-02-28 23:30:15</li>\n"
            + "<li>yyyyMMdd'T'HHmmss.SSSZ, for example: 20150228T233015.223</li>\n"
            + "<li>yyyyMMdd'T'HHmmssZ, for example: 20150228T233015</li>\n"
            + "<li>yyyy-MM-dd, for example: 2015-02-28</li>\n"
            + "<li>yyyyMMdd, for example: 20150228</li>\n"
            + "<li>yyyyMM, for example: 201502</li>\n"
            + "<li>yyyy, for example: 2015</li>\n"
            + "</ol>\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.util.UUID";
  }

  public Category[] getCategories() {
    return new Category[] { Category.datetime };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a per-host node and empty clock data.\n"
              + "The node and clock components are seeded from network interface data. In this case,\n"
              + "the clock data is not seeded uniquely.\n", 
            new LinkedHashMap<String, String>() {{
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToFinestTimeUUID()");
                add("basetime 0, computed node data, empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and empty clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param node a fixture value for testing that replaces node and clock bits\n", 
            new LinkedHashMap<String, String>() {{
              put("node","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToFinestTimeUUID(5234)");
                add("basetime 0, specified node data (5234), empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and specific clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param node  a fixture value for testing that replaces node bits\n"
              + "@param clock a fixture value for testing that replaces clock bits\n", 
            new LinkedHashMap<String, String>() {{
              put("node","long");
              put("clock","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToFinestTimeUUID(31,337)");
                add("basetime 0, specified node data (31) and clock data (337)");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a per-host node and empty clock data.\n"
              + "The node and clock components are seeded from network interface data. In this case,\n"
              + "the clock data is not seeded uniquely.\n"
              + "\n"
              + "@param baseTimeSpec - a string specification for the base time value\n", 
            new LinkedHashMap<String, String>() {{
              put("baseTimeSpec","java.lang.String");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToFinestTimeUUID('2017-01-01T23:59:59')");
                add("specified basetime, computed node data, empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and empty clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param baseTimeSpec - a string specification for the base time value\n"
              + "@param node         a fixture value for testing that replaces node and clock bits\n", 
            new LinkedHashMap<String, String>() {{
              put("baseTimeSpec","java.lang.String");
              put("node","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToFinestTimeUUID('2012',12345)");
                add("basetime at start if 2012, with node data 12345, empty clock data");
              }});
            }}
          ));
          add(new DocForFuncCtor("ToFinestTimeUUID", "Create version 1 timeuuids with a specific static node and specific clock data.\n"
              + "This is useful for testing so that you can know that values are verifiable, even though\n"
              + "in non-testing practice, you would rely on some form of entropy per-system to provide\n"
              + "more practical dispersion of values over reboots, etc.\n"
              + "\n"
              + "@param node         a fixture value for testing that replaces node bits\n"
              + "@param clock        a fixture value for testing that replaces clock bits\n"
              + "@param baseTimeSpec - a string specification for the base time value\n", 
            new LinkedHashMap<String, String>() {{
              put("baseTimeSpec","java.lang.String");
              put("node","long");
              put("clock","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("ToFinestTimeUUID('20171231T1015.243',123,456)");
                add("ms basetime, specified node and clock data");
              }});
            }}
          ));
        }};
  }
}
