/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class SaveFloat
implements LongFunction<Float> {
    private final String name;
    private final LongFunction<Object> nameFunc;

    @Example(value={"SaveFloat('foo')", "save the current float value to a named variable in this thread."})
    public SaveFloat(String name) {
        this.name = name;
        this.nameFunc = null;
    }

    @Example(value={"SaveFloat(NumberNameToString())", "save the current float value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveFloat(LongFunction<Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
    }

    @Override
    public Float apply(long value) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(value)) : this.name;
        map.put(varname, value);
        return Float.valueOf(value);
    }
}

