/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_long;

import io.virtdata.annotations.Description;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.lfsrs.MetaShift;

@ThreadSafeMapper
@Description(value="Provides virtual shuffling extremely large numbers.")
public class Shuffle
extends MetaShift.Func {
    private final long max;
    private final long min;
    private final long size;

    @Example(value={"Shuffle(11,99)", "Provide all values between 11 and 98 inclusive, in some order, then repeat"})
    public Shuffle(long min, long maxPlusOne) {
        this(min, maxPlusOne, Integer.MAX_VALUE);
    }

    @Example(value={"Shuffle(11,99,3)", "Provide all values between 11 and 98 inclusive, in some different (and repeatable) order, then repeat"})
    public Shuffle(long min, long maxPlusOne, int bankSelector) {
        super(MetaShift.Masks.forPeriodAndBankModulo(maxPlusOne - min, bankSelector));
        this.min = min;
        this.max = maxPlusOne;
        this.size = this.max - min;
    }

    @Override
    public long applyAsLong(long register) {
        register = register % this.size + 1L;
        register = super.applyAsLong(register);
        while (register > this.size) {
            register = super.applyAsLong(register);
        }
        return register += this.min;
    }
}

