/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_int.HashRange;
import io.virtdata.util.ResourceFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class HashedLineToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(HashedLineToString.class);
    private final HashRange indexRange;
    private List<String> lines = new ArrayList<String>();
    private final String filename;

    public HashedLineToString(String filename) {
        this.filename = filename;
        this.lines = ResourceFinder.readDataFileLines((String)filename);
        this.indexRange = new HashRange(0L, this.lines.size() - 2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public String apply(long operand) {
        int itemIdx = this.indexRange.applyAsInt(operand);
        String item = this.lines.get(itemIdx);
        return item;
    }
}

