/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
public class MapTemplate
implements LongFunction<Map<Object, Object>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction<Object> keyFunc;
    private final LongFunction<Object> valueFunc;
    private final boolean stringify;

    @Example(value={"MapTemplate(HashRange(3,7),NumberNameToString(),LastNames())", "create maps between 3 and 7 values big, with number names as the keys, and last names as the values"})
    public MapTemplate(LongToIntFunction sizeFunc, LongFunction<Object> keyFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.stringify = true;
        this.keyFunc = keyFunc;
        this.valueFunc = valueFunc;
    }

    @Example(value={"MapTemplate(false,HashRange(3,7),NumberNameToString(),HashRange(1300,1700))", "create a map of size 3-7 entries, with a key of type string and a value of type int (Integer by autoboxing)"})
    public MapTemplate(boolean stringify, LongToIntFunction sizeFunc, LongFunction<Object> keyFunc, LongFunction<Object> valueFunc) {
        this.sizeFunc = sizeFunc;
        this.stringify = stringify;
        this.keyFunc = keyFunc;
        this.valueFunc = valueFunc;
    }

    @Override
    public Map<Object, Object> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object keyObject = this.keyFunc.apply(value + (long)i);
            Object valueObject = this.valueFunc.apply(value + (long)i);
            if (this.stringify) {
                map.put(String.valueOf(keyObject), String.valueOf(valueObject));
                continue;
            }
            map.put(keyObject, valueObject);
        }
        return map;
    }
}

